package com.hero.ui.dialog;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Duplication;
import com.hero.ui.widgets.LevelTF;
import com.hero.ui.widgets.ModifierPanel;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class DuplicationDialog extends PowerDialog {

	private static final long serialVersionUID = 4194145930121452594L;

	private JLabel dupPointsLbl;

	private JLabel numberLbl;

	LevelTF dupPointsTF;

	LevelTF numberTF;

	JButton fileAssociationBtn;

	public DuplicationDialog(Duplication pk, boolean isNew) {
		super(pk, isNew, true);
	}

	void checkMods() {
		boolean reset = false;
		for (int i = 0; i < modifierPanels.size(); i++) {
			ModifierPanel panel = modifierPanels.get(i);
			if (GenericObject.findObjectByID(power.getAssignedModifiers(),
					panel.getModifier().getXMLID()) != null) {
				if (!panel.isSelected()) {
					reset = true;
					break;
				}
			}
		}
		if (reset
				|| (modifierPanels.size() != power.getAssignedModifiers()
						.size())) {
			layoutExtrasPanel();
		}
	}

	@Override
	protected JPanel getModsPanel() {
		JPanel mods = new JPanel(new FlowLayout(FlowLayout.CENTER));
		mods.add(fileAssociationBtn);
		mods.add(customAdderBtn);
		mods.add(privateAdderBtn);
		mods.add(addModifierBtn);
		return mods;
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 30;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);
		panel.add(dupPointsLbl, gbc);
		gbc.gridy = 40;
		gbc.gridy = 50;
		panel.add(numberLbl, gbc);
		gbc.gridy = 29;
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(damageLbl, gbc);
		gbc.gridy = 30;
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(dupPointsTF, gbc);
		gbc.gridy = 40;
		gbc.gridy = 50;
		panel.add(numberTF, gbc);
		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();

		fileAssociationBtn.addActionListener(new ActionListener() {
			JFileChooser chooser;

			public void actionPerformed(ActionEvent e) {
				File openFile = null;
				Duplication f = (Duplication) power;
				if ((f.getFilePath() != null)
						&& (f.getFilePath().trim().length() > 0)) {
					f.clearFilePath();
					fileAssociationBtn.setText("Associate File...");
					updateValues();
					return;
				} else {
					while (openFile == null) {
						if (chooser == null) {
							chooser = new JFileChooser();
							chooser
									.setFileFilter(new javax.swing.filechooser.FileFilter() {

										@Override
										public boolean accept(File file) {
											if (file.isDirectory()
													&& !file.getName()
															.toUpperCase()
															.endsWith(".PKG")
													&& !file.getName()
															.toUpperCase()
															.endsWith(".APP")) {
												return true;
											}
											if (file.getName().toUpperCase()
													.endsWith(".HDC")) {
												return true;
											} else {
												return false;
											}
										}

										@Override
										public String getDescription() {
											return "Hero Designer Character Files";
										}
									});
							chooser.setApproveButtonText("Associate Character");
							chooser.setDialogTitle("Open");
							chooser
									.setFileSelectionMode(JFileChooser.FILES_ONLY);
							chooser.setMultiSelectionEnabled(false);
							chooser.setAcceptAllFileFilterUsed(false);
							if ((HeroDesigner.getInstance().getPrefs()
									.getSaveDir() != null)
									&& (HeroDesigner.getInstance().getPrefs()
											.getSaveDir().trim().length() > 0)) {
								try {
									chooser.setCurrentDirectory(new File(
											HeroDesigner.getInstance()
													.getPrefs().getSaveDir()));
								} catch (Exception ex) {
								}
							}
						}
						int ret = chooser
								.showOpenDialog(DuplicationDialog.this);
						if (ret == JFileChooser.CANCEL_OPTION) {
							return;
						} else if (ret == JFileChooser.APPROVE_OPTION) {
							openFile = chooser.getSelectedFile();
							if (!openFile.exists()) {
								openFile = null;
							}
						}
					}
					if ((openFile == null) || openFile.isDirectory()) {
						return;
					}

					((Duplication) power).setFilePath(openFile
							.getAbsolutePath());
					dupPointsTF.setCurrent(((Duplication) power).getPoints());
					fileAssociationBtn.setText("Remove File Association");
					updateValues();
				}
			}
		});

		dupPointsTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						((Duplication) power).setPoints(dupPointsTF
								.getCurrent());
						updateValues();
						checkMods();
					}
				});
		numberTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						((Duplication) power).setMultiples(numberTF
								.getCurrent());
						updateValues();
					}
				});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		if (pointsLbl != null) {
			pointsLbl.setVisible(false);
		}
		if (pointsTF != null) {
			pointsTF.setVisible(false);
		}
		if (inputLbl != null) {
			inputLbl.setVisible(false);
		}
		if (exampleCombo != null) {
			exampleCombo.setVisible(false);
		}
		if (levelsLbl != null) {
			levelsLbl.setVisible(false);
		}
		if (levelTF != null) {
			levelTF.setVisible(false);
		}
		dupPointsLbl = new JLabel("Duplicate Points:");
		numberLbl = new JLabel("Number of Multiples:");
		dupPointsTF = new LevelTF(((Duplication) power).getPoints(), 9999, 0);
		numberTF = new LevelTF(((Duplication) power).getMultiples(), 9999, 1);
		fileAssociationBtn = new JButton("Associate File...");
		Duplication f = (Duplication) power;
		if ((f.getFilePath() != null) && (f.getFilePath().trim().length() > 0)) {
			fileAssociationBtn.setText("Remove File Association");
		}
	}

	@Override
	public void updateValues() {
		super.updateValues();
		Duplication check = (Duplication) power;
		if (check.getFilePath() != null) {
			damageLbl.setVisible(true);
			File file = new File(check.getFilePath());
			damageLbl.setText("(associated with " + file.getName() + ")");
		} else {
			damageLbl.setVisible(false);
		}
	}

}